﻿

/*! LAB.js (LABjs :: Loading And Blocking JavaScript)
    v2.0.3 (c) Kyle Simpson
    Modified by Benjamin Kristensen to include nonEssentialScript which skips loading errors
    MIT License
*/
!function (e) { function t(e) { return "[object Function]" == Object.prototype.toString.call(e) } function n(e) { return "[object Array]" == Object.prototype.toString.call(e) } function r(e, t) { var n = /^\w+\:\/\//; return /^\/\/\/?/.test(e) ? e = location.protocol + e : n.test(e) || "/" == e.charAt(0) || (e = (t || "") + e), n.test(e) ? e : ("/" == e.charAt(0) ? _ : m) + e } function i(e, t) { for (var n in e) e.hasOwnProperty(n) && (t[n] = e[n]); return t } function s(e) { for (var t = !1, n = 0; n < e.scripts.length; n++)e.scripts[n].ready && e.scripts[n].exec_trigger && (t = !0, e.scripts[n].exec_trigger(), e.scripts[n].exec_trigger = null); return t } function c(e, t, n, r) { e.onload = e.onreadystatechange = function () { e.readyState && "complete" != e.readyState && "loaded" != e.readyState || t[n] || (e.onload = e.onreadystatechange = null, r()) }, t.essential || (e.onerror = function () { r() }) } function o(e) { e.ready = e.finished = !0; for (var t = 0; t < e.finished_listeners.length; t++)e.finished_listeners[t](); e.ready_listeners = [], e.finished_listeners = [] } function a(e, t, n, r, i) { setTimeout(function () { var s, o, a = t.real_src; if ("item" in v) { if (!v[0]) return void setTimeout(arguments.callee, 25); v = v[0] } s = document.createElement("script"), t.type && (s.type = t.type), t.charset && (s.charset = t.charset), i ? L ? (e[y] && S("start script preload: " + a), n.elem = s, E ? (s.preload = !0, s.onpreload = r) : s.onreadystatechange = function () { "loaded" == s.readyState && r() }, s.src = a) : i && 0 == a.indexOf(_) && e[f] ? (o = new XMLHttpRequest, e[y] && S("start script preload (xhr): " + a), o.onreadystatechange = function () { 4 == o.readyState && (o.onreadystatechange = function () { }, n.text = o.responseText + "\n//@ sourceURL=" + a, r()) }, o.open("GET", a), o.send()) : (e[y] && S("start script preload (cache): " + a), s.type = "text/cache-script", c(s, n, "ready", function () { v.removeChild(s), r() }), s.src = a, v.insertBefore(s, v.firstChild)) : B ? (e[y] && S("start script load (ordered async): " + a), s.async = !1, c(s, n, "finished", r), s.src = a, v.insertBefore(s, v.firstChild)) : (e[y] && S("start script load: " + a), c(s, n, "finished", r), s.src = a, v.insertBefore(s, v.firstChild)) }, 0) } function l() { function m(e, t, n) { function r() { null != i && (i = null, o(n)) } var i; C[t.src].finished || (e[p] || (C[t.src].finished = !0), i = n.elem || document.createElement("script"), t.type && (i.type = t.type), t.charset && (i.charset = t.charset), c(i, n, "finished", r), n.elem ? n.elem = null : n.text ? (i.onload = i.onreadystatechange = null, i.text = n.text) : i.src = t.real_src, v.insertBefore(i, v.firstChild), n.text && r()) } function _(e, t, n, i) { var s, c, l = function () { t.finished_cb(t, n) }; t.src = r(t.src, e[g]), t.real_src = t.src + (e[h] ? (/\?.*$/.test(t.src) ? "&_" : "?_") + ~~(1e9 * Math.random()) + "=" : ""), C[t.src] || (C[t.src] = { items: [], finished: !1 }), c = C[t.src].items, e[p] || 0 == c.length ? (s = c[c.length] = { ready: !1, finished: !1, ready_listeners: [function () { t.ready_cb(t, function () { m(e, t, s) }) }], finished_listeners: [l] }, a(e, t, s, i ? function () { s.ready = !0; for (var e = 0; e < s.ready_listeners.length; e++)s.ready_listeners[e](); s.ready_listeners = [] } : function () { o(s) }, i)) : (s = c[0]).finished ? l() : s.finished_listeners.push(l) } function x() { function e(e, t) { u[y] && S("script preload finished: " + e.real_src), e.ready = !0, e.exec_trigger = t, c() } function r(e, t) { u[y] && S("script execution finished: " + e.real_src), e.ready = e.finished = !0, e.exec_trigger = null; for (var n = 0; n < t.scripts.length; n++)if (!t.scripts[n].finished) return; t.finished = !0, c() } function c() { for (; p < f.length;)if (t(f[p])) { u[y] && S("$LAB.wait() executing: " + f[p]); try { f[p++]() } catch (e) { u[y] && b("$LAB.wait() error caught: ", e) } } else { if (!f[p].finished) { if (s(f[p])) continue; break } p++ } p == f.length && (h = !1, l = !1) } function o() { l && l.scripts || f.push(l = { scripts: [], finished: !0 }) } var a, l, u = i(E, {}), f = [], p = 0, h = !1; return a = { script: function () { for (var s = 0; s < arguments.length; s++)!function (s, c) { var f; n(s) || (c = [s]); for (var p = 0; p < c.length; p++)o(), t(s = c[p]) && (s = s()), s && (n(s) ? ((f = [].slice.call(s)).unshift(p, 1), [].splice.apply(c, f), p--) : ("string" == typeof s && (s = { src: s }), s = i(s, { ready: !1, ready_cb: e, finished: !1, finished_cb: r, essential: !0 }), l.finished = !1, l.scripts.push(s), _(u, s, l, B && h), h = !0, u[d] && a.wait())) }(arguments[s], arguments[s]); return a }, nonEssentialScript: function () { for (var s = 0; s < arguments.length; s++)!function (s, c) { var f; n(s) || (c = [s]); for (var p = 0; p < c.length; p++)o(), t(s = c[p]) && (s = s()), s && (n(s) ? ((f = [].slice.call(s)).unshift(p, 1), [].splice.apply(c, f), p--) : ("string" == typeof s && (s = { src: s }), s = i(s, { ready: !1, ready_cb: e, finished: !1, finished_cb: r, essential: !1 }), l.finished = !1, l.scripts.push(s), _(u, s, l, B && h), h = !0, u[d] && a.wait())) }(arguments[s], arguments[s]); return a }, wait: function () { if (arguments.length > 0) { for (var e = 0; e < arguments.length; e++)f.push(arguments[e]); l = f[f.length - 1] } else l = !1; return c(), a } }, { script: a.script, nonEssentialScript: a.nonEssentialScript, wait: a.wait, setOptions: function (e) { return i(e, u), a } } } var w, E = {}, B = L || O, A = [], C = {}; return E[f] = !0, E[d] = !1, E[p] = !1, E[h] = !1, E[y] = !1, E[g] = "", w = { setGlobalDefaults: function (e) { return i(e, E), w }, setOptions: function () { return x().setOptions.apply(null, arguments) }, script: function () { return x().script.apply(null, arguments) }, nonEssentialScript: function () { return x().nonEssentialScript.apply(null, arguments) }, wait: function () { return x().wait.apply(null, arguments) }, queueScript: function () { return A[A.length] = { type: "script", args: [].slice.call(arguments) }, w }, queueWait: function () { return A[A.length] = { type: "wait", args: [].slice.call(arguments) }, w }, runQueue: function () { for (var e, t = w, n = A.length; --n >= 0;)t = t[(e = A.shift()).type].apply(null, e.args); return t }, noConflict: function () { return e.$LAB = u, w }, sandbox: function () { return l() } } } var u = e.$LAB, f = "UseLocalXHR", d = "AlwaysPreserveOrder", p = "AllowDuplicates", h = "CacheBust", y = "Debug", g = "BasePath", m = /^[^?#]*\//.exec(location.href)[0], _ = /^\w+\:\/\/\/?[^\/]+/.exec(m)[0], v = document.head || document.getElementsByTagName("head"), x = e.opera && "[object Opera]" == Object.prototype.toString.call(e.opera) || "MozAppearance" in document.documentElement.style, S = function () { }, b = S, w = document.createElement("script"), E = "boolean" == typeof w.preload, L = E || w.readyState && "uninitialized" == w.readyState, B = !L && !0 === w.async, O = !L && !B && !x; e.console && e.console.log && (e.console.error || (e.console.error = e.console.log), S = function (t) { e.console.log(t) }, b = function (t, n) { e.console.error(t, n) }), e.$LAB = l(), function (e, t, n) { null == document.readyState && document.addEventListener && (document.readyState = "loading", document.addEventListener("DOMContentLoaded", n = function () { document.removeEventListener("DOMContentLoaded", n, !1), document.readyState = "complete" }, !1)) }() }(this);


var wizdomInject = function (
    version,
    appUrl,
    blobUrl,
    includeConfigurationAttributes,
    includeAdminScripts,
    includeCustomScripts,
    partnerModules,
    wizdomEnvironmentIsOnPrem,
    wizdomEnvironmentIsOnPrem2013,
    customModules,
    bootstrapElementFunc,
    internalModules,
    clientId,
    skipStyleLoading
) {

    log("Wizdom Scriptloader starting");

    // default values
    var wizdomScriptLoaderVars = window["WizdomScriptLoaderVars"] = window["WizdomScriptLoaderVars"] || {};
    var featureToggles = window["wizdomClientSideFeatureToggles"] = window["wizdomClientSideFeatureToggles"] || {};
    var wizdomCDNs = window["wizdomCDNs"] = {
        wizdom: "//wizdom.azureedge.net",
        libsOne: "//wizdom-libs-one.azureedge.net",
        libsTwo: "//wizdom-libs-two.azureedge.net",
        libsThree: "//wizdom-libs-three.azureedge.net"
    };
    var wizdomResources = window["wizdomResources"] = {
        css: {
            AdminStyles: ((!blobUrl || blobUrl === "/") ? "/Base/Bundles/AdminStyles.min.css?v={wizdomVersion}" : "{cdnWizdomOne}/css/{wizdomVersion}/content/AdminStyles.min.css"),
            Styles: ((!blobUrl || blobUrl === "/") ? "/Base/Bundles/Styles.min.css?v={wizdomVersion}": "{cdnWizdomTwo}/css/{wizdomVersion}/content/Styles.min.css"),
            BootstrapNoWrapped: ((!blobUrl || blobUrl === "/") ? "/Base/Bundles/StylesBootstrapNoWrapped.min.css?v={wizdomVersion}" : "{cdnWizdomThree}/css/{wizdomVersion}/content/StylesBootstrapNoWrapped.min.css"),
            Bootstrap: ((!blobUrl || blobUrl === "/") ? "/Base/Bundles/StylesBootstrap.min.css?v={wizdomVersion}" : "{cdnWizdomOne}/css/{wizdomVersion}/content/StylesBootstrap.min.css"),
            EndUserStyles: ((!blobUrl || blobUrl === "/") ? "/Base/Bundles/EndUserStyles.min.css?v={wizdomVersion}" : "{cdnWizdomTwo}/css/{wizdomVersion}/content/EndUserStyles.min.css"),
            StylesModules: ((!blobUrl || blobUrl === "/") ? "/Base/Bundles/StylesModules.min.css?v={wizdomVersion}" : "{cdnWizdomThree}/css/{wizdomVersion}/content/StylesModules.min.css"),
            CssGenerator: null,
            CustomStyles: null,
            AzuremediaplayerCss: "{cdnWizdomThree}/libs/amp/1.1.0/skins/amp-default/azuremediaplayer.min.css"
        },
        js: {
            Jquery: "{cdnWizdomOne}/libs/jquery/3.4.1/jquery.min.js",
            JqueryUI: "{cdnWizdomOne}/libs/jquery-ui/1.12.1/jquery-ui.min.js",
            Moment: "{cdnWizdomOne}/libs/moment/2.10.2/moment-with-locales.min.js",
            Angular: "{cdnWizdomOne}/libs/angular/1.7.9/angular.min.js",
            AngularRoute: "{cdnWizdomThree}/libs/angular-route/1.7.9/angular-route.js",
            AngularAnimate: "{cdnWizdomOne}/libs/angular/1.7.9/angular-animate.min.js",
            AngularLocale: "{cdnWizdomOne}/libs/angular-i18n/1.7.9/angular-locale_{locale}.js",
            Lodash: "{cdnWizdomTwo}/libs/lodash/3.5.0/lodash.min.js",
            Tweenlite: "{cdnWizdomTwo}/libs/gsap/1.16.1/TweenLite.min.js",
            Masonry: "{cdnWizdomTwo}/libs/masonry/3.3.0/masonry.pkgd.min.js",
            Cssplugin: "{cdnWizdomTwo}/libs/gsap/1.16.1/plugins/CSSPlugin.min.js",
            Azuremediaplayer: "{cdnWizdomThree}/libs/amp/1.1.0/azuremediaplayer.min.js",
            AzuremediaplayerFlashSwf: "{cdnWizdomThree}/libs/amp/1.1.0/techs/StrobeMediaPlayback.2.0.swf",
            AzuremediaplayerFlashPlugin: "{cdnWizdomThree}/libs/amp/1.1.0/techs/MSAdaptiveStreamingPlugin-osmf2.0.swf",
            AzuremediaplayerSilverlightSSXP: "{cdnWizdomThree}/libs/amp/1.1.0/techs/SmoothStreamingPlayer.xap",

            // Wizdom scripts
            WizdomScriptsBundle: "{cdnWizdom}/scripts/{wizdomVersion}/Scripts.js",
            WizdomAdminScripts: "{cdnWizdom}/scripts/{wizdomVersion}/AdminScripts.js",
            WizdomApp: isSaaS ? "{cdnWizdom}/scripts/{wizdomVersion}/appSaaS.js" : "{cdnWizdom}/scripts/{wizdomVersion}/app.js",
            WizdomAppAdmin: "{cdnWizdom}/scripts/{wizdomVersion}/app.admin.js",
            WizdomAppEdit: "{cdnWizdom}/scripts/{wizdomVersion}/app.editmode.js",

            // MSal
            AngularMsal: appUrl + "Base/Scripts/msal-angular.js?v={wizdomVersion}",
            AngularMsalConfig: appUrl + "Base/msalConfig.js?v={wizdomVersion}",

            CustomScripts: null,
            Configuration: null,
            translations: null,
            templates: null
        }
    };

    if (!blobUrl || blobUrl === "/") { // speciel case for localhost/Dev        
        wizdomResources.js.WizdomScriptsBundle = appUrl + "Base/Bundles/Scripts.min.js?v={wizdomVersion}";
        wizdomResources.js.WizdomAdminScripts = appUrl + "Base/Bundles/AdminScripts.js?v={wizdomVersion}";
        wizdomResources.js.WizdomApp = appUrl + "Base/Bundles/AppSaaS.js?v={wizdomVersion}";
        wizdomResources.js.WizdomAppAdmin = appUrl + "Base/Bundles/App.Admin.js?v={wizdomVersion}";
        wizdomResources.js.WizdomAppEdit = appUrl + "Base/Bundles/App.Editmode.js?v={wizdomVersion}";
        //if (!isSaaS) {
        //wizdomResources.js.Configuration = appUrl + "Base/Bundles/configuration.aspx";
        //wizdomResources.js.Configuration = appUrl + "Base/Bundles/configuration.aspx?IncludeAttributes=true&{ticks}";
        // customizations
        wizdomResources.js.CustomScripts = null; // appUrl + "Base/Bundles/CustomScripts.aspx";
        wizdomResources.css.CustomStyles = null; // appUrl + "Base/Bundles/CustomStyles.aspx";
        wizdomResources.css.CssGenerator = null; // appUrl + "Base/Bundles/CssGenerator.aspx";
        //wizdomResources.js.translations = appUrl + "Base/Bundles/translations.aspx";
        wizdomResources.js.templates = null; // appUrl + "Base/Bundles/templates.aspx";
        //}
        wizdomResources.js.translations = null; // appUrl + "Base/Bundles/translations.aspx";
    }

    // replace variables in urls
    function encodeForBlob(s) {
        var re = /[^0-9a-zA-Z-_]/g; // Must match regex used in string extension EncodeForBlob() */
        return s.replace(re, '_').toLowerCase();
    }
    function calculatePostFix(configCollection) {

        var longestUrlLength = -1;
        var postFix = "";
        configCollection.forEach(function (config) {
            if (config) {
                var regex = new RegExp(config, 'i'); // i: case insensitive
                if (config.length > longestUrlLength && regex.test(window.location.href)) {
                    postFix = encodeForBlob(config);
                    longestUrlLength = config.length;
                }
            }
        });
        return postFix;
    }
    function calculateCssGeneratorPostFix() {
        var postFix = "";
        var wizdomScriptLoaderVars = window["WizdomScriptLoaderVars"];
        if (wizdomScriptLoaderVars && wizdomScriptLoaderVars.CssGeneratorConfigurations) {
            postFix = calculatePostFix(wizdomScriptLoaderVars.CssGeneratorConfigurations);
        }
        return postFix;
    }
    function calculateCssPostFix() {
        var postFix = "";
        var wizdomScriptLoaderVars = window["WizdomScriptLoaderVars"];
        if (wizdomScriptLoaderVars && wizdomScriptLoaderVars.CustomStylesConfigurations) {
            postFix = calculatePostFix(wizdomScriptLoaderVars.CustomStylesConfigurations);
            //                postFix = encodeURIComponent(postFix).toLowerCase();
        }
        return postFix;
    }
    function calculateCustomJsPostFix() {
        var postFix = "";
        var wizdomScriptLoaderVars = window["WizdomScriptLoaderVars"];
        if (wizdomScriptLoaderVars && wizdomScriptLoaderVars.CustomJavascriptConfigurations) {
            postFix = calculatePostFix(wizdomScriptLoaderVars.CustomJavascriptConfigurations);
        }
        return postFix;
    }

    var locale = "en-us";
    var cssGeneratorTimestamp = wizdomScriptLoaderVars["timestampCss"] || "";
    var customStyleTimestamp = wizdomScriptLoaderVars["timestampCustomStyles"] || "";
    var customScriptTimestamp = wizdomScriptLoaderVars["timestampCustomScripts"] || "";
    var configurationTimestamp = wizdomScriptLoaderVars["timestampConfiguration"] || "";
    var translationsTimestamp = wizdomScriptLoaderVars["timestampTranslation"] || "";
    var templatesTimestamp = wizdomScriptLoaderVars["timestampHtmlTemplates"] || "";
    var cssPostFix = calculateCssPostFix();
    var cssGeneratorPostFix = calculateCssGeneratorPostFix();
    var customJsPostFix = calculateCustomJsPostFix();
    var ticks = new Date().getTime();
    for (var ressourceType in wizdomResources) {
        for (var resource in wizdomResources[ressourceType]) {
            if (!wizdomResources[ressourceType][resource])
                continue;
            wizdomResources[ressourceType][resource] = wizdomResources[ressourceType][resource]
                .replace(/{cdnWizdomOne}/gi, wizdomCDNs.libsOne)
                .replace(/{cdnWizdomTwo}/gi, wizdomCDNs.libsTwo)
                .replace(/{cdnWizdomThree}/gi, wizdomCDNs.libsThree)
                .replace(/{cdnWizdom}/gi, wizdomCDNs.wizdom)
                .replace(/{wizdomVersion}/gi, version)
                .replace(/{locale}/gi, locale)
                .replace(/{blobOrAppUrl}/gi, (blobUrl || appUrl))
                .replace(/{cssGeneratorTimestamp}/gi, cssGeneratorTimestamp)
                .replace(/{customStyleTimestamp}/gi, customStyleTimestamp)
                .replace(/{customScriptTimestamp}/gi, customScriptTimestamp)
                .replace(/{cssPostFix}/gi, cssPostFix)
                .replace(/{cssGeneratorPostFix}/gi, cssGeneratorPostFix)
                .replace(/{customJsPostFix}/gi, customJsPostFix)
                .replace(/{ticks}/gi, ticks)
                .replace(/{configurationTimestamp}/gi, configurationTimestamp)
                .replace(/{translationsTimestamp}/gi, translationsTimestamp)
                .replace(/{templatesTimestamp}/gi, templatesTimestamp);
        }
    }

    window["Wizdom365ResourcesUrl"] = (blobUrl || appUrl);

    // load CSS
    var cssFiles =
        [
            // admin mode
            wizdomResources.css.AdminStyles,
            wizdomResources.css.Styles,
            // "normal" mode
            wizdomResources.css.BootstrapNoWrapped,
            wizdomResources.css.Bootstrap,
            wizdomResources.css.Styles,
            wizdomResources.css.EndUserStyles,
            wizdomResources.css.StylesModules,
            wizdomResources.css.CssGenerator,
            wizdomResources.css.CustomStyles
        ];

    // add customModules css
    if (customModules !== null && customModules.length > 0) {
        customModules.forEach(function (moduleInfo) {
            if ((moduleInfo.Enabled && moduleInfo.CssLink !== null && moduleInfo.CssLink.length > 0)) {
                cssFiles.push(moduleInfo.CssLink + "?v=" + version + "&mv=" + moduleInfo.Version);
            }
        });
    }

    // load the css files
    if (!skipStyleLoading) {
        while (cssFile = cssFiles.shift()) {
            var elm = window.document.createElement("link");
            elm.rel = "stylesheet";
            elm.href = cssFile;
            var head = document.head || document.getElementsByTagName("head")[0];
            head.appendChild(elm);
        }
    }

    function loadAuth() {
        $LAB
            .script(wizdomResources.js.Jquery)
            .script(wizdomResources.js.Moment)
            .script(wizdomResources.js.Lodash)
            .script(wizdomResources.js.Tweenlite)
            .wait()
            .script(wizdomResources.js.Angular)
            .script(wizdomResources.js.Cssplugin)
            .wait()
            //.script("https://cdnjs.cloudflare.com/ajax/libs/angular-sanitize/1.7.9/angular-sanitize.js")
            .script(wizdomResources.js.AngularRoute)
            .script(wizdomResources.js.AngularAnimate)
            .script(wizdomResources.js.AngularLocale)
            .script(wizdomResources.js.AngularMsal)
            .script(wizdomResources.js.AngularMsalConfig)
            .script(wizdomResources.js.JqueryUI)
            .wait(function () {                
                angular.module("Wizdom365Auth", ["MsalAngular"]);
                angular.module("Wizdom365Auth").config(['$locationProvider', function ($locationProvider) {
                    $locationProvider.html5Mode(false).hashPrefix('');
                }]);
                angular.module("Wizdom365Auth").config(['msalAuthenticationServiceProvider', '$httpProvider', function (msalProvider, $httpProvider) {
                    msalProvider.init(msalConfig.options, $httpProvider);
                }]);
                angular.module("Wizdom365Auth").run(["$rootScope", "msalAuthenticationService", "$http", "$window", function ($rootScope, msalService, $http, $window) {
                    // I am rebootstrapping Wizdom365Auth with Wizdom356 as submodule. To handle second bootstrapping, we break out on this variable
                    if (window["authComplete"]) 
                        return;

                    $rootScope.loading = true;
                    
                    log("Wizdom Auth Starting");                    
                    
                    $rootScope.$on("msal:loginSuccess", function (event, tokenOut) {     
                        if (!window["authComplete"])
                            log("Wizdom Login Success");
                        loadConfigThenWizdom($http);
                    });

                    $rootScope.$on("msal:acquireTokenSuccess", function (event, tokenOut) {       
                        if (!window["authComplete"])
                            log("Wizdom Acquire Token Success");    
                        loadConfigThenWizdom($http);
                    });
                    
                    $rootScope.$on("msal:acquireTokenFailure", function (event, errorDesc, error) {
                        log("Wizdom Acquire Token Failure", errorDesc, error);
                        if (errorDesc === "user_login_error") {
                            if (document.body.getElementsByTagName("login").length > 0) { // admin page
                                $rootScope.showLogin = true;
                            } else {
                                msalService.loginRedirect(msalConfig.scopes); // other pages like login
                            }
                        } else {
                            msalService.acquireTokenRedirect(msalConfig.scopes);
                        }
                    });
                    
                    if (msalService.userInfo.isAuthenticated) {
                        if (!window["authComplete"])
                            log("Wizdom Auth isAuthenticated");
                        loadConfigThenWizdom($http);
                    }
                    else if (window.location.href.indexOf("id_token") === -1)
                        msalService.acquireTokenSilent(msalConfig.scopes);                        
                }]);
                angular.module("Wizdom365Auth").directive("login", login);
                function login() {
                    return {
                        replace: true,
                        templateUrl: "../Base/Templates/Login.html?v=" + version,
                        controller: LoginController
                    };
                }
                LoginController.$inject = ["$scope", "msalAuthenticationService", "$window"];
                function LoginController($scope, msalService, $window) {
                    $scope.login = function () {
                        msalService.loginRedirect(window["msalConfig"].scopes);
                    };
                    $scope.signup = function () {
                        $window.location.href = "/base/pages/signup.aspx";
                    };
                }

                var dummyElm = document.getElementById("Wizdom365AuthElement");                
                angular.bootstrap(dummyElm, ["Wizdom365Auth"], { strictDi: true });
            });
    }
    function loadConfigThenWizdom($http) {                
        if (!window["authComplete"]) {
            window["authComplete"] = true;            
            log("Wizdom Auth completed");

            if (!window["Wizdom365Config"]) {
                $http.get("/api/wizdom/365/configuration").then(function (result) {
                    window["Wizdom365Config"] = result.data;
                    loadWizdom();
                });
            }
            else {
                loadWizdom();
            }
        }
    }
    function loadWizdom() {
        var scriptLoader = $LAB
            .script(wizdomResources.js.translations)
            .script(wizdomResources.js.WizdomScriptsBundle)
            .script(wizdomResources.js.WizdomAdminScripts)
            .wait()
            .nonEssentialScript(function () {
                // load custom modules
                var rtnVal = [];
                if (customModules !== null && customModules.length > 0 && includeCustomScripts) {
                    customModules.forEach(function (moduleInfo) {
                        if ((moduleInfo.Enabled && moduleInfo.JsLink !== null && moduleInfo.JsLink.length > 0)) {
                            rtnVal.push(moduleInfo.JsLink + "?v=" + version + "&mv=" + moduleInfo.Version);
                        }
                    });
                }
                return rtnVal;
            })
            .wait()
            .script(wizdomResources.js.WizdomApp)
            .wait()
            .script(wizdomResources.js.templates); // Load templates after app.js to ensure customized templates will overwrite Wizdom base templates.

            if (document.readyState === "complete") {
                loadLastResources();
            }
            else {
                document.addEventListener("DOMContentLoaded", function (event) {
                    loadLastResources();
                });
        }

        function loadLastResources() {
            var requestedModules = [];
            var requestSequence = [];

            logTime("Scanning for Wizdom modules");
            if (internalModules !== null && internalModules.length > 0) {
                var cdnLocation = wizdomCDNs.wizdom + "/scripts/" + version + "/";

                internalModules.forEach(function (moduleInfo) {
                    var scriptInfoIndex = 0;
                    moduleInfo.Scripts.forEach(function (scriptInfo) {
                        if (requestSequence[scriptInfoIndex] == null)
                            requestSequence[scriptInfoIndex] = [];
                        scriptInfo.Srcs.forEach(function (src) {
                            var url = src;
                            requestedModules.push(src);
                            //if (!scriptloaderSettings.getAppScriptsFromCDN || scriptloaderSettings.CDNType === "Local" || !blobUrl) {
                            //    url = (blobUrl || appUrl) + src;
                            //    requestSequence[scriptInfoIndex].push(url + "?v=" + version);
                            //}
                            //else {
                            if (blobUrl && blobUrl !== "/") {                                
                                url = cdnLocation + (url.replace("Base/Bundles/", ""));
                            } else 
                                url = url[0] !== "/" ? "/" + url : url; // Ensure leading slash
                            requestSequence[scriptInfoIndex].push(url + "?v=" + version);
                            //}
                        });                    
                        scriptInfoIndex++;
                    });
                });
            }
            logTimeEnd("Scanning for Wizdom modules");


            log("Loading Wizdom modules");
            requestSequence.forEach(function (sequence) {
                scriptLoader.script(sequence).wait();
            });

            scriptLoader
                .script(wizdomResources.js.WizdomAppAdmin)
                .script(wizdomResources.js.WizdomAppEdit)
                .script(appUrl + "Base/Scripts/froala/froala.js?v=" + version)            
                .wait(function () {
                    logTimeEnd("Wizdom scripts loaded");

                    angular.bootstrap(document.body, ["Wizdom365Auth"], { strictDi: true });
                });
        }
    }
    loadAuth();
};

if (!wizdomInject) {
    wizdomInject = function () { };
}